﻿using SnapsLibrary;
using System.Collections.Generic;

class Ch10_04_TimeTrackerClass
{
    class Contact
    {
        public string ContactName;
        public string ContactAddress;
        public string ContactPhone;

        public int ContactMinutesSpent;

        public Contact(string name, string address, string phone)
        {
            this.ContactName = name;
            this.ContactAddress = address;
            this.ContactPhone = phone;
            this.ContactMinutesSpent = 0;
        }
    }


    void makeTestData()
    {
        string[] testNames = {
            "Rob", "Marysia", "Dawid", "Joanna",
            "Szymon", "Konarad", "Helena", "Krzysiek",
            "Amanda", "Sandra" };

        // liczba minut dla kontaktów
        int minutes = 0;

        foreach (string name in testNames)
        {
            Contact newContact = new Contact(name: name,
                address: name + " dom",
                phone: name + " dom");
            newContact.ContactMinutesSpent = minutes;
            minutes = minutes + 30;
            storeContact(newContact);
        }
    }

    List<Contact> contacts = new List<Contact>();

    void storeContact(Contact contact)
    {
        contacts.Add(contact);
    }

    void newContact()
    {
        SnapsEngine.SetTitleString("Nowy kontakt");
        string name = SnapsEngine.ReadString("Wpisz nazwę nowego kontaktu");
        string address = SnapsEngine.ReadMultiLineString("Wspisz adres kontaktu");
        string phone = SnapsEngine.ReadString("Wpisz telefon kontaktu");

        Contact newContact = new Contact(name: name, address: address, phone: phone);

        storeContact(newContact);

        SnapsEngine.DisplayString("Kontakt został zapisany");
    }

    void findContact()
    {
        SnapsEngine.SetTitleString("Znajdź kontakt");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");

        bool foundAContact = false;

        SnapsEngine.ClearTextDisplay();

        foreach (Contact contact in contacts)
        {
            if (contact.ContactName == name)
            {
                SnapsEngine.AddLineToTextDisplay("Nazwa: " + contact.ContactName);
                SnapsEngine.AddLineToTextDisplay("Adres: " + contact.ContactAddress);
                SnapsEngine.AddLineToTextDisplay("Telefon: " + contact.ContactPhone);
                SnapsEngine.AddLineToTextDisplay("Minuty: " + contact.ContactMinutesSpent.ToString());
                foundAContact = true;
                break;
            }
        }

        if (!foundAContact)
            SnapsEngine.AddLineToTextDisplay("Nie znaleziono kontaktu");

        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.ClearTextDisplay();
    }

    void addMinutes()
    {
        SnapsEngine.SetTitleString("Dodaj minuty");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");
        int minutes = SnapsEngine.ReadInteger("Wpisz minuty dla kontaktu");

        bool foundAContact = false;

        SnapsEngine.ClearTextDisplay();

        for (int position = 0; position < contacts.Count; position = position + 1)
        {
            if (contacts[position].ContactName == name)
            {
                SnapsEngine.AddLineToTextDisplay("Liczba dodanych minut: " + minutes + "\n" +
                    "do " + name);
                contacts[position].ContactMinutesSpent = contacts[position].ContactMinutesSpent + minutes;
                foundAContact = true;
                break;
            }
        }

        if (!foundAContact)
            SnapsEngine.AddLineToTextDisplay("Nie znaleziono kontaktu");

        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.ClearTextDisplay();
    }

    void displaySummary()
    {
        SnapsEngine.SetTitleString("Wyświetl podsumowanie");

        for (int pass = 0; pass < contacts.Count - 1; pass = pass + 1)
        {
            for (int i = 0; i < contacts.Count - 1; i = i + 1)
            {
                if (contacts[i].ContactMinutesSpent < contacts[i + 1].ContactMinutesSpent)
                {
                    // elementy są w złej kolejności, trzeba je pozamieniać
                    Contact temp = contacts[i];
                    contacts[i] = contacts[i + 1];
                    contacts[i + 1] = temp;
                }
            }
        }

        SnapsEngine.SetTitleString("Czasy kontaktów");

        SnapsEngine.ClearTextDisplay();

        for (int position = 0; position < 5; position = position + 1)
        {
            if (contacts[position].ContactName == null)
                break;
            SnapsEngine.AddLineToTextDisplay(contacts[position].ContactName +
                ":" + contacts[position].ContactMinutesSpent);
        }

        SnapsEngine.WaitForButton("Dalej");

        SnapsEngine.ClearTextDisplay();
    }

    public void StartProgram()
    {
        // Usuń tę instrukcję, zanim sprzedaż program
        makeTestData();

        while (true)
        {
            SnapsEngine.SetTitleString("Rejestr czasu pracy");

            string command = SnapsEngine.SelectFrom4Buttons("Nowy kontakt", "Znajdź kontakt",
                "Dodaj minuty", "Wyświetl podsumowanie");

            switch (command)
            {
                case "Nowy kontakt":
                    newContact();
                    break;

                case "Znajdź kontakt":
                    findContact();
                    break;

                case "Dodaj minuty":
                    addMinutes();
                    break;

                case "Wyświetl podsumowanie":
                    displaySummary();
                    break;
            }
        }
    }
}
